package jadean.dean.java.resources;


import jadean.dean.Resource;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaProject;
import jadean.dean.java.utilities.FileUtilities;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaResourceProjectPackage extends JavaResourceProjectResource {

	public JavaResourceProjectPackage(String name, JavaResourceContext context, JavaProject p) {
		super(name, context, p);
	}

	@Override
	public Collection<Resource> getReferrencedResources() {
		List<String> folders = new ArrayList<String>();
		for (String folder: this.getProject().getSourceFolders()) {
			folders.add(folder + File.separatorChar + this.getName().replace(".*", "").replace('.', File.separatorChar));
		}
		List<File> files = FileUtilities.filesInDirs(folders);
		ArrayList<Resource> ret = new ArrayList<Resource>();
		JavaResourceFactory rf = new JavaResourceFactory(this.getProject());
		for (File f: files) {
			if (f.getName().toLowerCase().endsWith(".java")) {
				String className = this.getName().replace(".*", "") + "." + f.getName().replace(".java", "");
				ret.add(rf.classNameToResource(className, JavaResourceContextFactory.getResourceContext(this.getProject(), className)));
			}
		}
		return ret;
	}

	@Override
	public JavaPackage getPackageForResource() {
		return null;
	}

	@Override
	public void delete() {
		List<String> folders = new ArrayList<String>();
		for (String folder: this.getProject().getSourceFolders()) {
			folders.add(folder + File.separatorChar + this.getName().replace(".*", "").replace('.', File.separatorChar));
		}
		List<File> files = FileUtilities.filesInDirs(folders);
		for (File f: files) {
			f.delete();
		}
	}

}
